package com.xebialabs.xlrelease.events.handlers

import com.xebialabs.xlrelease.domain.events.UserProfileDeletedEvent
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import com.xebialabs.xlrelease.security.UserGroupService
import com.xebialabs.xlrelease.service.UserTokenService
import grizzled.slf4j.Logging
import org.springframework.stereotype.Service

@Service
@EventListener
class UserProfileDeletedEventHandler(userTokenService: UserTokenService, userGroupService: UserGroupService) extends Logging {

  @Subscribe
  def onUserProfileDeleted(event: UserProfileDeletedEvent): Unit = {
    logger.info(s"User[${event.profile.getCanonicalId}] is deleted. Going to delete all associated personal access tokens with the user.")
    val tokenUser: String = event.profile.getCanonicalId
    userTokenService.deleteAllUserToken(tokenUser)
    userGroupService.updateGroupsMembershipForUser(tokenUser, Set[String]())
  }
}
