package com.xebialabs.xlrelease.repository;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

/**
 * Persistence interceptors allow us to modify objects just before they're being persisted into the database.
 */
public interface PersistenceInterceptor<T extends ConfigurationItem> {
    default void onCreate(T ci) {
    }

    default void onDelete(String ciId) {
    }

    default void onUpdate(T ci) {
    }

    default void afterCreate(T ci) {
    }

    default void afterUpdate(T ci){

    }

    default void afterDelete(String ciId) {
    }

}
