package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.configuration.TenantLimit
import grizzled.slf4j.Logging

trait TenantLimitRepository {
  self: Logging =>

  def findByTenantId(tenantId: String): Option[TenantLimit]

  def findAll(): Seq[TenantLimit]

  def create(limit: TenantLimit): TenantLimit

  def update(limit: TenantLimit): Unit

  def delete(tenantId: String): Unit

  def getEffectiveLimit(tenantId: String): TenantLimit
}
