package com.xebialabs.xlrelease.scheduler.events.handlers

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.actors.initializer.SubscriptionInitializer
import com.xebialabs.xlrelease.domain.runner.JobRunner
import com.xebialabs.xlrelease.events.EventBus
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.scheduler.events.JobRunnerCreatedOrUpdatedEvent
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class JobRunnerActorInitializer(configurationRepository: ConfigurationRepository,
                                eventBus: EventBus) extends SubscriptionInitializer {

  override def initialize(): Unit = {
    val runners = configurationRepository.findAllByType[JobRunner](Type.valueOf(classOf[JobRunner]))
    runners.asScala.foreach(r => eventBus.publish(JobRunnerCreatedOrUpdatedEvent(r)))
  }
}
