package com.xebialabs.xlrelease.spring.configuration;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Role;
import org.springframework.core.Ordered;

@Role(BeanDefinition.ROLE_INFRASTRUCTURE)
public class MultipartElementBeanPostProcessor implements BeanPostProcessor, BeanFactoryAware, Ordered {

    private BeanFactory beanFactory;

    @Override
    public Object postProcessAfterInitialization(final Object bean, final String beanName) throws BeansException {
        if (bean instanceof ServletRegistrationBean<?> b) {
            b.setMultipartConfig(new DeferredMultipartConfigElement(beanFactory));
        }
        return bean;
    }

    @Override
    public void setBeanFactory(final BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }


    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }
}
