/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.limits;

import com.xebialabs.xlrelease.configuration.TenantLimit;
import com.xebialabs.xlrelease.exception.RateLimitReachedException;
import com.xebialabs.xlrelease.repository.TenantLimitRepository;
import com.xebialabs.xlrelease.security.authority.TenantAuthority;
import com.xebialabs.xlrelease.utils.TenantContext;
import java.util.Optional;
import java.util.function.IntSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class LimitEnforcer {
    private static final Logger logger = LoggerFactory.getLogger(LimitEnforcer.class);
    private final TenantLimitRepository tenantLimitRepository;

    public LimitEnforcer(TenantLimitRepository tenantLimitRepository) {
        this.tenantLimitRepository = tenantLimitRepository;
    }

    public void enforceLimit(String tenantId, LimitType limitType, int increment, IntSupplier currentCountSupplier) {
        this.enforceLimit(tenantId, limitType, increment, currentCountSupplier, Optional.empty());
    }

    public void enforceLimit(String tenantId, LimitType limitType, int increment, IntSupplier currentCountSupplier, Optional<String> limitExceededMessage) {
        if (this.isGlobalAdmin()) {
            logger.debug("Global admin bypassing {} limit (system-wide bypass)", (Object)limitType.getResourceName());
            return;
        }
        TenantLimit tenantLimit = this.tenantLimitRepository.getEffectiveLimit(tenantId);
        if (!tenantLimit.isEnabled()) {
            logger.debug("Limit enforcement is disabled for tenant: {}", (Object)tenantId);
            return;
        }
        int limit = this.getConfiguredLimit(limitType, tenantLimit);
        if (limit < 0) {
            logger.debug("Unlimited {} allowed for tenant: {}", (Object)limitType.getResourceName(), (Object)tenantId);
            return;
        }
        int currentCount = currentCountSupplier.getAsInt();
        if (currentCount + increment > limit) {
            String message = this.buildLimitExceededMessage(limitType, limit, limitExceededMessage);
            throw new RateLimitReachedException(message);
        }
        logger.debug("Limit enforcement passed for tenant {}: {} {}/{}", new Object[]{tenantId, limitType.getResourceName(), currentCount, limit});
    }

    private int getConfiguredLimit(LimitType limitType, TenantLimit tenantLimit) {
        return switch (limitType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> tenantLimit.getMaxFolders();
            case 1 -> tenantLimit.getMaxTeamMembers();
            case 2 -> tenantLimit.getMaxTeamsPerFolder();
            case 3 -> tenantLimit.getMaxConnections();
            case 4 -> tenantLimit.getMaxTemplates();
            case 5 -> tenantLimit.getMaxRunningReleases();
            case 10 -> tenantLimit.getMaxWorkflowTemplates();
            case 11 -> tenantLimit.getMaxWorkflowExecutions();
            case 16 -> tenantLimit.getMaxTriggers();
            case 17 -> tenantLimit.getMaxPatterns();
            case 18 -> tenantLimit.getMaxDeliveries();
            case 6 -> tenantLimit.getMaxTemplatePhases();
            case 7 -> tenantLimit.getMaxTemplateTasks();
            case 8 -> tenantLimit.getMaxReleasePhases();
            case 9 -> tenantLimit.getMaxReleaseTasks();
            case 12 -> tenantLimit.getMaxWorkflowPhases();
            case 13 -> tenantLimit.getMaxWorkflowTasks();
            case 14 -> tenantLimit.getMaxWorkflowExecutionPhases();
            case 15 -> tenantLimit.getMaxWorkflowExecutionTasks();
            case 19 -> tenantLimit.getMaxApplications();
            case 20 -> tenantLimit.getMaxEnvironments();
            case 21 -> tenantLimit.getMaxDashboards();
            case 22 -> tenantLimit.getMaxDashboardTiles();
            case 23 -> tenantLimit.getMaxGlobalVariables();
            case 24 -> tenantLimit.getMaxFolderVariables();
            case 25 -> tenantLimit.getMaxReleaseVariables();
            case 26 -> tenantLimit.getMaxVariableValueSize();
        };
    }

    private String buildLimitExceededMessage(LimitType limitType, int limit, Optional<String> limitExceededMessage) {
        return limitExceededMessage.orElseGet(() -> String.format("%s limit of %d reached. You cannot add more %s.", limitType.getDisplayName(), limit, limitType.getDisplayName().toLowerCase()));
    }

    private boolean isGlobalAdmin() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            return false;
        }
        String systemTenantId = TenantContext.SYSTEM_TENANT_ID();
        for (GrantedAuthority authority : SecurityContextHolder.getContext().getAuthentication().getAuthorities()) {
            if (!(authority instanceof TenantAuthority) || !systemTenantId.equals(authority.getAuthority())) continue;
            return true;
        }
        return false;
    }

    public static enum LimitType {
        FOLDERS("Folders", "folders"),
        TEAM_MEMBERS("Team members", "team members"),
        FOLDER_TEAMS("Folder teams", "folder teams"),
        CONNECTIONS("Connections", "connections"),
        TEMPLATES("Templates", "templates"),
        RELEASES("Running releases", "running releases"),
        TEMPLATE_PHASES("Template phases", "template phases"),
        TEMPLATE_TASKS("Template tasks", "template tasks"),
        RELEASE_PHASES("Release phases", "release phases"),
        RELEASE_TASKS("Release tasks", "release tasks"),
        WORKFLOW_TEMPLATES("Workflow templates", "workflow templates"),
        WORKFLOW_EXECUTIONS("Workflow executions", "workflow executions"),
        WORKFLOW_PHASES("Workflow phases", "workflow phases"),
        WORKFLOW_TASKS("Workflow tasks", "workflow tasks"),
        WORKFLOW_EXECUTION_PHASES("Workflow execution phases", "workflow execution phases"),
        WORKFLOW_EXECUTION_TASKS("Workflow execution tasks", "workflow execution tasks"),
        TRIGGERS("Triggers", "triggers"),
        PATTERNS("Patterns", "patterns"),
        DELIVERIES("Deliveries", "deliveries"),
        APPLICATIONS("Applications", "applications"),
        ENVIRONMENTS("Environments", "environments"),
        DASHBOARDS("Dashboards", "dashboards"),
        DASHBOARD_TILES("Dashboard tiles", "dashboard tiles"),
        GLOBAL_VARIABLES("Global variables", "global variables"),
        FOLDER_VARIABLES("Folder variables", "folder variables"),
        RELEASE_VARIABLES("Release variables", "release variables"),
        VARIABLE_VALUE_SIZE("Variable value size", "variable value size");

        private final String displayName;
        private final String resourceName;

        private LimitType(String displayName, String resourceName) {
            this.displayName = displayName;
            this.resourceName = resourceName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getResourceName() {
            return this.resourceName;
        }
    }
}

