package com.xebialabs.xlrelease.actors

import com.esotericsoftware.kryo.kryo5.ClassResolver
import com.esotericsoftware.kryo.kryo5.util.DefaultClassResolver
import com.xebialabs.xlplatform.utils.ClassLoaderUtils.classLoader
import com.xebialabs.xlrelease.actors.kryoserializers._
import com.xebialabs.xlrelease.repository.proxy.{ResolvableConfigurationItemReference, ResolvableLazyConfigurationItem}
import com.xebialabs.xlrelease.runner.domain.ConfigureRunner
import com.xebialabs.xlrelease.script.TaskSoftReference
import grizzled.slf4j.Logging
import io.altoo.serialization.kryo.pekko.DefaultKryoInitializer
import io.altoo.serialization.kryo.scala.KryoSerializationSettings
import io.altoo.serialization.kryo.scala.serializer.ScalaKryo

class KryoInit extends DefaultKryoInitializer with Logging {
  override def postInit(kryo: ScalaKryo): Unit = {
    JavaKaffeeSerializers(kryo)
    TwitterChillSerializers(kryo)

    // kryo.setWarnUnregisteredClasses(false)
    kryo.addDefaultSerializer(classOf[ResolvableLazyConfigurationItem], ResolvableLazyConfigurationItemSerializer)
    kryo.addDefaultSerializer(classOf[TaskSoftReference[_]], TaskSoftReferenceSerializer)
    kryo.addDefaultSerializer(classOf[ConfigureRunner], ConfigureRunnerSerializer)

    kryo.register(classOf[ResolvableLazyConfigurationItem])
    kryo.register(classOf[ResolvableConfigurationItemReference])

    // mechanism so we can register custom serializers from other spring modules
    KryoInitializers.postInit(kryo)

    val tccl = classLoader
    kryo.setClassLoader(tccl)
  }

  override def createClassResolver(settings: KryoSerializationSettings): ClassResolver = {
    val original = new DefaultClassResolver()
    new XlrClassResolver(original)
  }

}
