package com.xebialabs.xlrelease.api.v1.impl;

import java.util.List;
import org.springframework.stereotype.Controller;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.api.v1.MetadataApi;
import com.xebialabs.xlrelease.api.v1.views.ExplodedDescriptor;

@Controller
public class MetadataApiImpl implements MetadataApi {
    @Override
    public ExplodedDescriptor findDescriptor(final Type type) {
        return new ExplodedDescriptor(DescriptorRegistry.getDescriptor(type));
    }

    public List<ExplodedDescriptor> listAll() {
        return DescriptorRegistry.getDescriptors().stream().map(ExplodedDescriptor::new).toList();
    }

    @Override
    public List<String> getTypes(List<String> superTypes) {
        return DescriptorRegistry.getDescriptors().stream()
                .filter(descriptor -> superTypes == null || superTypes.isEmpty() ||
                        descriptor.getSuperClasses().stream()
                                .map(Type::toString)
                                .anyMatch(superType ->
                                        superTypes.stream().anyMatch(s -> s.equalsIgnoreCase(superType))
                                )
                )
                .map(descriptor -> descriptor.getType().toString())
                .toList();
    }
}
