package com.xebialabs.xlrelease.service

import com.xebialabs.xlrelease.domain.{Changes, Phase}
import com.xebialabs.xlrelease.repository.PhaseRepository

import scala.jdk.CollectionConverters._

trait ChangeProcessor {

  def phaseRepository: PhaseRepository

  def processPhases(changes: Changes): Unit = {
    val phases = changes.getUpdatedItems.asScala
      .filter(_.isInstanceOf[Phase])
      .map(_.asInstanceOf[Phase])
      .toSet
    val updatedPhasesCount = phaseRepository.batchUpdateProperties(phases)

    //As of 24.1, release does not store data in XLR_PHASES table and there is currently no upgrader to populate the data
    //This can be removed in future versions after 25.x maybe
    if (phases.nonEmpty && updatedPhasesCount <= 0) {
      phases.groupBy(_.getReleaseUid).foreach {
        case (releaseUid, gPhases) => phaseRepository.batchInsertProperties(gPhases, releaseUid)
      }
    }
  }

}
