package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.configuration.ThemeColor
import com.xebialabs.xlrelease.configuration.ThemeColors.fromOldCodeWithDefaultGreen
import com.xebialabs.xlrelease.configuration.ThemeSettings.THEME_SETTINGS_ID
import com.xebialabs.xlrelease.domain.BaseConfiguration
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class XLRelease800ThemeSettingsUpgrade @Autowired()(configurationRepository: ConfigurationRepository) extends Upgrade with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "8.0.0#0")

  override def doUpgrade(): Boolean = {
    if (configurationRepository.exists(THEME_SETTINGS_ID)) {
      val themeSettingsConfig = configurationRepository.read[BaseConfiguration](THEME_SETTINGS_ID)
      val headerAccentColor = Option(themeSettingsConfig.getProperty[String]("headerAccentColor"))
          .fold(ThemeColor.GREEN)(fromOldCodeWithDefaultGreen)
      themeSettingsConfig.setProperty("headerAccentColor", headerAccentColor.name())
      configurationRepository.update(themeSettingsConfig)
    }
    true
  }

}
