package com.xebialabs.xlrelease.utils

object QuartzUtils {

  implicit class QuartzCron(val cron: String) extends AnyVal {
    def asQuartzCron: String = cron.split(" ").filterNot(_.trim == "").toList match {
      case s :: min :: h :: d :: m :: wd :: Nil =>
        val (newDay, newWeekDay) = d -> wd match {
          case (_, "?") | ("?", _) => d -> wd
          case (_, "*") => d -> "?"
          case ("*", _) => "?" -> wd
          case other => other
        }
        s"$s $min $h $newDay $m $newWeekDay"
      case _ =>
        cron
    }
  }

}
