package com.xebialabs.xlrelease.views;

import java.util.Map;

import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.variable.VariableHelper;

public class VariableOrValueView extends VariableOrValue {

    public VariableOrValueView() {
        super();
    }

    public VariableOrValueView(final String variable, final Object value) {
        super(variable, value);
        if (variable == null) {
            if (value instanceof String && VariableHelper.containsOnlyVariable((String) value)) {
                this.setVariable((String) value);
                this.setValue(null);
            }
        }
    }

    public VariableOrValueView(Map<String, Object> deserializedView) {
        this((String) deserializedView.get("variable"), deserializedView.get("value"));
    }

}
