package com.xebialabs.xlrelease.actors.initializer

import com.xebialabs.xlrelease.actors.initializer.ActorInitializerOrder.ARCHIVE_PURGING
import com.xebialabs.xlrelease.actors.{ActorSystemHolder, ArchivePurgingActor}
import com.xebialabs.xlrelease.config.XlrConfig
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

@Component
class ArchivePurgingInitializer(xlrConfig: XlrConfig, systemHolder: ActorSystemHolder)
  extends ManagedActorInitializer with Logging {

  private lazy val archivePurgingActor = if (xlrConfig.isClusterEnabled) {
    systemHolder.clusterSingletonActorOf[ArchivePurgingActor](classOf[ArchivePurgingActor], ArchivePurgingActor.name)
  } else {
    systemHolder.actorOf[ArchivePurgingActor](classOf[ArchivePurgingActor], ArchivePurgingActor.name)
  }

  override def doStart(): Unit = {
    if (xlrConfig.maintenanceModeEnabled) {
      logger.debug("[MAINTENANCE MODE] Archive purge scheduler actor - DISABLED")
    } else {
      logger.debug("Initializing archive purging actor...")
      archivePurgingActor
    }
  }

  override def doStop(): Unit = ()

  override def getOrder: Int = ARCHIVE_PURGING
}
