package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.Team
import com.xebialabs.xlrelease.repository.SecurityRepository.TeamId

case class TeamArrayPropertyChange(add: Set[String], remove: Set[String])

trait SecurityRepository {

  def getTeam(teamId: TeamId): Team

  def createTeam(containerId: String,
                 teamName: String,
                 roles: Set[String] = Set.empty,
                 principals: Set[String] = Set.empty,
                 permissions: Set[String] = Set.empty): TeamId

  def updateTeam(teamId: TeamId, roles: TeamArrayPropertyChange, principals: TeamArrayPropertyChange, permissions: TeamArrayPropertyChange): TeamId

  def deleteTeam(teamId: TeamId): Unit

  def findTeamId(containerId: String, teamName: String): Option[TeamId]

  def findTeamById(containerId: String, teamId: TeamId): Option[Team]

  def findTeamByName(containerId: String, teamName: String): Option[Team]

  def addPrincipalsToTeam(teamId: TeamId, principals: Set[String]): Unit

  def removePrincipalsFromTeam(teamId: TeamId, principals: Set[String]): Unit

  def addRolesByNameToTeam(teamId: TeamId, roleNames: Set[String]): Unit

  def removeRolesByNameFromTeam(teamId: TeamId, rolesNames: Set[String]): Unit

  def addPermissionsToTeam(teamId: TeamId, principals: Set[String]): Unit

  def removePermissionsFromTeam(teamId: TeamId, principals: Set[String]): Unit
}

object SecurityRepository {
  type TeamId = String
}
