package com.xebialabs.xlrelease.spring.configuration;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.session.jdbc.*;

import com.xebialabs.xlrelease.db.sql.DatabaseInfo;

@Configuration
class SessionRegistryConfiguration {

    /**
     * sessionRegistry to use in case of jetty managed session.
     * For spring-session, see com.xebialabs.xlrelease.spring.configuration.SpringSessionConfiguration#sessionRegistry()
     */
    @Bean
    @ConditionalOnProperty(value = "xl.server.session.storage.enabled", havingValue = "false")
    public SessionRegistry sessionRegistry() {
        return new SessionRegistryImpl();
    }

    @Bean
    @ConditionalOnProperty(value = "xl.server.session.storage.enabled", havingValue = "true")
    public SessionRepositoryCustomizer<JdbcIndexedSessionRepository> sessionRepositoryCustomizer(@Qualifier("xlrDbInfo") DatabaseInfo dbInfo) {
        if (dbInfo instanceof DatabaseInfo.Db2) {
            return new Db2JdbcIndexedSessionRepositoryCustomizer();
        } else if (dbInfo instanceof DatabaseInfo.Oracle) {
            return new OracleJdbcIndexedSessionRepositoryCustomizer();
        } else if (dbInfo instanceof DatabaseInfo.MsSqlServer) {
            return new SqlServerJdbcIndexedSessionRepositoryCustomizer();
        } else if (dbInfo instanceof DatabaseInfo.MySql) {
            return new MySqlJdbcIndexedSessionRepositoryCustomizer();
        } else if (dbInfo instanceof DatabaseInfo.PostgreSql) {
            return new PostgreSqlJdbcIndexedSessionRepositoryCustomizer();
        }
        return null;
    }
}
