package com.xebialabs.deployit.plumbing.serialization

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION
import com.xebialabs.xlrelease.domain.BaseConfiguration
import com.xebialabs.xlrelease.repository.ConfigurationRepository

import java.util.regex.Pattern
import scala.jdk.CollectionConverters._

case class PortableConfigurationReference(idPrefix: String, title: String, ciType: Type) {
  def portableReferenceId: String = idPrefix + title

  def resolve(configurationRepository: ConfigurationRepository, resolutionContext: ResolutionContext): Option[BaseConfiguration] = {
    if (null == resolutionContext) {
      configurationRepository.findAllByTypeAndTitle(ciType, title).asScala.headOption
    } else {
      configurationRepository.findAllByTypeAndTitle(ciType, title, resolutionContext.folderId.orNull, false).asScala.headOption
    }
  }
}

object PortableConfigurationReference {

  val CONFIGURATION_ID_PATTERN: Pattern = Pattern.compile("^(" + CONFIGURATION.getRootNodeName + "/.+?/)(.+?)$")

  def splitTypeAndIdFromConfigurationId(id: String): Option[(String, String)] = {
    val matcher = CONFIGURATION_ID_PATTERN.matcher(id)
    if (matcher.matches() && matcher.groupCount() == 2) {
      Some(matcher.group(1), matcher.group(2))
    } else {
      None
    }
  }

  def from(ciType: Type, portableId: String): Option[PortableConfigurationReference] = {
    splitTypeAndIdFromConfigurationId(portableId).map {
      case (prefix, title) => PortableConfigurationReference(prefix, title, ciType)
    }
  }

  def from(configuration: BaseConfiguration): Option[PortableConfigurationReference] = {
    splitTypeAndIdFromConfigurationId(configuration.getId).map {
      case (prefix, _) => PortableConfigurationReference(prefix, configuration.getTitle, configuration.getType)
    }
  }
}
