package com.xebialabs.xlrelease.actors.initializer

import com.xebialabs.xlrelease.actors.initializer.ActorInitializerOrder.ARCHIVING
import com.xebialabs.xlrelease.actors.{ActorSystemHolder, ArchivingActor}
import com.xebialabs.xlrelease.config.XlrConfig
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

@Component
class ArchivingInitializer(xlrConfig: XlrConfig, systemHolder: ActorSystemHolder)
  extends ManagedActorInitializer with Logging {

  private lazy val archivingActor = if (xlrConfig.isClusterEnabled) {
    systemHolder.clusterSingletonActorOf[ArchivingActor](classOf[ArchivingActor], ArchivingActor.name)
  } else {
    systemHolder.actorOf[ArchivingActor](classOf[ArchivingActor], ArchivingActor.name)
  }

  override def doStart(): Unit = {
    if (xlrConfig.maintenanceModeEnabled) {
      logger.debug("[MAINTENANCE MODE] Archiving actor - DISABLED")
    } else {
      logger.debug("Initializing archiving actor...")
      archivingActor
    }
  }

  override def doStop(): Unit = ()

  override def getOrder: Int = ARCHIVING
}
