package com.xebialabs.xlrelease.api.v1.impl;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.deployit.plumbing.CurrentVersion;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlrelease.api.v1.SettingsApi;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.views.LicenseView;

import static com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN;
import static com.xebialabs.xlrelease.security.XLReleasePermissions.AUDIT_ALL;

@Controller
public class SettingsApiImpl implements SettingsApi {
    private final ConfigurationRepository configurationRepository;
    private final PermissionChecker permissions;
    private final LicenseService licenseService;

    @Autowired
    public SettingsApiImpl(final ConfigurationRepository configurationRepository, final PermissionChecker permissions, LicenseService licenseService) {
        this.configurationRepository = configurationRepository;
        this.permissions = permissions;
        this.licenseService = licenseService;
    }

    @Override
    public BaseConfiguration getSettings(final String id) {
        permissions.checkAny(ADMIN, AUDIT_ALL);
        return configurationRepository.read(id);
    }

    @Override
    public Map<String, String> getInstanceInformation() {
        Map<String, String> properties = new HashMap<>();
        LicenseView licenseView = new LicenseView(licenseService.getLicense());
        properties.put("product", licenseView.getProduct());
        properties.put("edition", licenseView.getEdition());
        properties.put("version", CurrentVersion.get());
        return properties;
    }
}
