package com.xebialabs.xlrelease.authentication

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.Primary
import org.springframework.security.core.userdetails.{UserDetails, UserDetailsService, UsernameNotFoundException}
import org.springframework.stereotype.Component

@Primary
@Component("defaultUserDetailsService")
class DelegatingUserDetailsService extends UserDetailsService {

  @Autowired
  var userDetailsServices: Array[UserDetailsService] = _

  @throws[UsernameNotFoundException]
  override def loadUserByUsername(username: String): UserDetails = {
    var last: RuntimeException = null
    var userDetails: UserDetails = null;
    for (uds <- userDetailsServices if userDetails == null) {
      try {
        userDetails = uds.loadUserByUsername(username)
      }
      catch {
        case error: RuntimeException =>
          last = error
      }
    }
    if (userDetails == null) {
      if (last == null) {
        throw new UsernameNotFoundException(f"User $username not found")
      } else {
        throw last
      }
    }
    userDetails
  }
}
