package com.xebialabs.xlrelease.domain.tasks.gate;

import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdateDirective;
import com.xebialabs.xlrelease.domain.tasks.task.DefaultTaskUpdater;
import org.springframework.stereotype.Component;

import java.util.Set;

@Component
public class GateTaskUpdater extends DefaultTaskUpdater {

    @Override
    public Class<? extends Task> getTaskClass() {
        return GateTask.class;
    }

    @Override
    public Changes update(Task original, Task updated, Set<TaskUpdateDirective> updateDirectives) {
        Changes changes = super.update(original, updated, updateDirectives);
        if (hasDirectiveToUpdateAllProperties(original, updateDirectives)) {
            changes.update(original);
            updateGate((GateTask) original, (GateTask) updated);
            taskConcurrencyService.updateLastModifiedDetails(original);
        }
        return changes;
    }

    private void updateGate(GateTask original, GateTask updated) {
        original.setTransitionToFailed(updated.isTransitionToFailed());
    }
}
