package com.xebialabs.xlrelease.features

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.features.distributed.{BaseDistributedFeature, DistributedFeature}
import com.xebialabs.xlrelease.features.settings.{MaxTokenExpirationDuration, NoExpirationDuration, PersonalAccessTokenFeatureSettings}

trait PersonalAccessTokenFeature extends DistributedFeature {
  def enabled: Boolean

  def maxTokenExpiry: Int
}

object PersonalAccessTokenFeature
  extends BaseDistributedFeature[PersonalAccessTokenFeatureSettings]
    with PersonalAccessTokenFeature {
  override def enabled: Boolean = featureSettings.enabled

  private val defaultMaxTokenExpiry: MaxTokenExpirationDuration = Type.valueOf(classOf[NoExpirationDuration]).getDescriptor.newInstance("")

  override def maxTokenExpiry: Int = Option(featureSettings.maxTokenExpiration.duration).getOrElse(defaultMaxTokenExpiry.duration)
}
