package com.xebialabs.xlrelease.features.distributed

import com.xebialabs.xlrelease.service.{XlrServiceLifecycle, XlrServiceLifecycleOrder}
import org.springframework.stereotype.Component

@Component
class DistributedFeaturesManager(features: Array[DistributedFeature]) extends XlrServiceLifecycle {

  override def doStart(): Unit = {
    // whenever actor system is re-started product should re-fetch values from the database
    features.foreach(_.reset())
  }

  override def doStop(): Unit = {
    // nothing needed
  }

  override def getOrder: Int = XlrServiceLifecycleOrder.FEATURES
}
