package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty

@Metadata(label = "Task editing settings",
  description = "Flag to inform user on concurrent task update when task has been modified by another user."
)
class TaskUpdateVersioningFeatureSettings extends FeatureSettings {
  @BeanProperty
  @XLProperty(label = "Enable concurrent Task edit checking in User Interface",
    description = "Receive notification in the User Interface when editing a task that has been concurrently modified by another user.",
    category = "input",
    defaultValue = "false")
  var concurrentTaskModificationProtectionEnabled: Boolean = _

  @BeanProperty
  @XLProperty(label = "Enable concurrent Task edit checking in API",
    description = "Receive notification through the API when updating a task that has been concurrently modified by another user.",
    category = "input",
    defaultValue = "false")
  var apiConcurrentTaskModificationProtectionEnabled: Boolean = _

  @BeanProperty
  @XLProperty(defaultValue = "experimental", hidden = true)
  var displayPage: String = _

  @BeanProperty
  @XLProperty(defaultValue = "how-to/configure-experimental-settings", hidden = true)
  var documentationPage: String = _

  @XLProperty(defaultValue = "30", hidden = true)
  var weight: Integer = _
}

