package com.xebialabs.xlrelease.repository;

import java.util.Collection;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.CiReader;

public class CiListAsReferencesReader extends CiListMemoryReader {

    public CiListAsReferencesReader(final Collection<ConfigurationItem> cis) {
        super(cis);
    }

    @Override
    public CiReader getCurrentCiReader() {
        return new CiAsReferenceMemoryReader(currentCi);
    }

    private class CiAsReferenceMemoryReader extends CiMemoryReader {

        public CiAsReferenceMemoryReader(final ConfigurationItem ci) {
            super(ci);
        }

        @Override
        public boolean isCiReference() {
            return true;
        }

        @Override
        public String getCiReference() {
            return ci.getId();
        }
    }
}
