package com.xebialabs.xlrelease.repository

import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken

import java.util.{Date, List => JList}

trait CustomPersistentTokenRepository {

  def createNewToken(persistentRememberMeToken: PersistentRememberMeToken): Unit

  def getTokenForSeries(series: String): PersistentRememberMeToken

  def getPreviousTokenForSeries(series: String, token: String): JList[PersistentRememberMeToken]

  def removeUserTokens(username: String): Unit

  def removeTokenInSeriesBeforeGivenDate(series: String, date: Date): Unit

  def removeUserTokensBasedOnSeries(series: String): Unit

}
