package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.variables.Variable
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository
import com.xebialabs.xlrelease.repository.sql.persistence.CiUid

import java.util.{List => JList}

trait FolderVariableRepository extends InterceptedRepository[Variable] {

  def exists(variableId: String): Boolean

  def findById(variableId: String): Variable

  def findByKey(variableKey: String, variableHolderId: String): Variable

  def create(variable: Variable): Variable

  def create(variable: Variable, folderCiUid: CiUid): Variable

  def update(variable: Variable): Variable

  def update(variable: Variable, folderCiUid: CiUid): Variable

  def delete(variableId: String): Unit

  def getAllFromParent(variableParentId: String): JList[Variable]

  def getAllFromAncestry(variableParentId: String): JList[Variable]
}
