package com.xebialabs.xlrelease.repository

import java.util.Optional

case class Page(page: Long, resultsPerPage: Long, depth: Integer, pageIsOffset: Boolean = false) {
  def offset: Long = if (pageIsOffset) page else page * resultsPerPage
}

object Page {
  val DEFAULT_DEPTH: Integer = 1
  val DEPTH_FOLDER_WITH_PERMISSIONS = 2
  val DEFAULT_PAGE: Long = 0L
  val DEFAULT_RESULTS_PER_PAGE: Long = 50L

  val default = Page(DEFAULT_PAGE, DEFAULT_RESULTS_PER_PAGE, DEFAULT_DEPTH)

  def parse(page: Optional[Long], resultsPerPage: Optional[Long], depth: Optional[Integer], pageIsOffset: Optional[Boolean]): Page = {
    if (!pageIsOffset.isPresent) {
      parse(page, resultsPerPage, depth)
    } else {
      Page(
        page.orElse(DEFAULT_PAGE),
        resultsPerPage.orElse(DEFAULT_RESULTS_PER_PAGE),
        depth.orElse(DEFAULT_DEPTH),
        pageIsOffset.orElse(false)
      )
    }
  }

  def parse(page: Optional[Long], resultsPerPage: Optional[Long], depth: Optional[Integer]): Page = {
    if (page.isPresent || resultsPerPage.isPresent || depth.isPresent) {
      Page(
        page.orElse(DEFAULT_PAGE),
        resultsPerPage.orElse(DEFAULT_RESULTS_PER_PAGE),
        depth.orElse(DEFAULT_DEPTH)
      )
    } else {
      Page.default
    }
  }
}
