package com.xebialabs.xlrelease.scheduler

import com.xebialabs.xlrelease.service.{XlrServiceLifecycle, XlrServiceLifecycleOrder}

import java.util.concurrent.ConcurrentHashMap

trait ExecutorsRegistry extends XlrServiceLifecycle {
  override def getOrder: Int = XlrServiceLifecycleOrder.EXECUTORS

  override def serviceName(): String = "ExecutorsLifecycleManager"
}

object ExecutorsRegistry extends ExecutorsRegistry {
  private val executors: ConcurrentHashMap[String, RestartableExecutorService] = new ConcurrentHashMap

  def put(name: String, executor: RestartableExecutorService): Unit = {
    if (executors.containsKey(name)) {
      throw new IllegalStateException(s"Executor '$name' was already created")
    }
    executors.put(name, executor)
  }

  override def doStart(): Unit = {
    executors.values().forEach(_.start())
  }

  override def doStop(): Unit = {
    executors.values().forEach(_.stop())
  }

  // this method must be used only in tests to cleanup
  private[scheduler] def destroy(): Unit = {
    stop()
    executors.clear()
  }
}
