package com.xebialabs.xlrelease.script.el

import org.springframework.expression.spel.standard.SpelExpressionParser
import org.springframework.expression.{Expression, ParseException, ParserContext}

class ElSecureExpressionParser extends SpelExpressionParser {

  private val MATCHES_OPERATOR_ERROR = "The 'matches' operator is not permitted"

  override def parseExpression(expressionString: String, context: ParserContext): Expression = {
    validateNoMatchesOperator(expressionString)
    super.parseExpression(expressionString, context)
  }

  private def validateNoMatchesOperator(expressionString: String): Unit = {
    // Check for matches operator pattern in the expression
    // The regex looks for word boundaries around "matches" followed by at least one whitespace character
    // This should catch most legitimate uses of the 'matches' operator
    val matchesPattern = "\\bmatches\\s".r

    if (matchesPattern.findFirstIn(expressionString).isDefined) {
      throw new ParseException(0, MATCHES_OPERATOR_ERROR)
    }
  }
}
