package com.xebialabs.xlrelease.script.el

import com.xebialabs.xlrelease.domain.Task
import com.xebialabs.xlrelease.script.ScriptVariables
import org.springframework.expression.spel.support.SimpleEvaluationContext
import org.springframework.expression.{EvaluationContext, MethodResolver}

import scala.jdk.CollectionConverters._

class EvaluationContextBuilder(scriptVariables: ScriptVariables,
                               methodResolver: MethodResolver) {

  def buildPreconditionContext(task: Task): EvaluationContext = {
    val releaseVars = scriptVariables.initialReleaseVariables(task.getRelease).asScala.map { case (k, v) => k -> v.getValue }.asJava
    val folderVars = scriptVariables.initialFolderVariables(task.getRelease.findFolderId()).asScala.map { case (k, v) => k -> v.getValue }.asJava
    val globalVars = scriptVariables.initialGlobalVariables().asScala.map { case (k, v) => k -> v.getValue }.asJava

    val preconditionContext = new ElPreconditionContext(task, releaseVars, folderVars, globalVars)
    val context = SimpleEvaluationContext.forReadOnlyDataBinding()
      .withMethodResolvers(methodResolver)
      .withRootObject(preconditionContext)
      .build()

    context
  }
}
