package com.xebialabs.xlrelease.script.el

import com.xebialabs.xlrelease.script.el.MethodAccessCheck.{AccessAllowed, AccessCheckResult, AccessDenied}

trait MethodAccessCheck {

  final def checkAccess(targetObject: Any, methodName: String): AccessCheckResult = {
    if (targetObject.isInstanceOf[Class[_]]) {
      AccessDenied(s"Static method access to `$methodName` on `$targetObject` is not permitted")
    } else {
      if (targetObject != null && targetObject.getClass != null) {
        val targetClassName = targetObject.getClass.getName
        checkAccess(targetClassName, methodName)
      } else {
        AccessAllowed
      }
    }
  }

  def checkAccess(targetClassName: String, methodName: String): AccessCheckResult
}

object MethodAccessCheck {
  sealed trait AccessCheckResult
  object AccessAllowed extends AccessCheckResult
  case class AccessDenied(msg: String) extends AccessCheckResult
}
