package com.xebialabs.xlrelease.security

trait UserGroupService {
  /**
   * Returns list of groups assigned to the user
   */
  def findGroupsForUser(username: String): Set[String]

  /**
   * Creates a new group with given name if does not exist
   */
  def createGroup(groupName: String): Unit

  /**
   * Deletes a group with given name if exists
   */
  def deleteGroup(groupName: String): Unit

  /**
   * Creates a new group if does not exist and assigns group membership to the supplied user
   */
  def addUserToGroup(username: String, groupName: String): Unit

  /**
   * Removes group membership for the supplied user
   */
  def removeUserFromGroup(username: String, groupName: String): Unit

  /**
   * Assigns or removes group membership for the user based on supplied groupNames
   */
  def updateGroupsMembershipForUser(username: String, groupNames: Set[String]): Unit
}
