package com.xebialabs.xlrelease.service

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.platform.script.jython.JythonContext.withLibrariesAndFactory
import com.xebialabs.platform.script.jython.ScriptSource.byContent
import com.xebialabs.platform.script.jython.{JythonSupport, ScriptSource, Syntactic}
import com.xebialabs.xlrelease.domain.ScriptHelper

import java.io.{PrintWriter, Writer}
import javax.script.{ScriptContext, SimpleScriptContext}

trait BaseJythonSupport[T <: ConfigurationItem] extends JythonSupport {

  def execute(configItem: T, libraries: Seq[ScriptSource], contextAttrs: Map[String, Object], out: Writer, err: Writer): Unit = {

    val scriptContent = ScriptHelper.getScript(configItem)
    val scriptContext = buildScriptContext(contextAttrs, out, err)

    implicit val jythonContext = withLibrariesAndFactory(libraries :+ Syntactic.loggerLib)(scriptContext)

    executeScript(byContent(scriptContent))
  }

  private def buildScriptContext(contextAttrs: Map[String, Object], out: Writer, err: Writer): SimpleScriptContext = {
    val context = new SimpleScriptContext()
    contextAttrs foreach { case (key, value) => context.setAttribute(key, value, ScriptContext.ENGINE_SCOPE) }
    context.setWriter(new PrintWriter(out))
    context.setErrorWriter(new PrintWriter(err))
    context
  }

}
