package com.xebialabs.xlrelease.service

import com.xebialabs.xlrelease.domain.Task
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent
import com.xebialabs.xlrelease.events.XLReleaseEventBus
import com.xebialabs.xlrelease.repository.{CiCloneHelper, TaskRepository}
import io.micrometer.core.annotation.Timed
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import java.util.{Set => JSet}

@Service
class TaskWatchersService @Autowired()(taskRepository: TaskRepository, eventBus: XLReleaseEventBus ) {

  @Timed
  def addWatcher(taskId: String, watcher: String): JSet[String] = {
    val task: Task = taskRepository.findById(taskId)
    val original = CiCloneHelper.cloneCi(task)
    LockedTaskOperationChecks.checkAddWatcher(task)
    task.addWatcher(watcher)
    taskRepository.update(task)
    eventBus.publish(TaskUpdatedEvent(original, task))
    task.getWatchers
  }

  @Timed
  def removeWatcher(taskId: String, watcher: String): JSet[String] = {
    val task: Task = taskRepository.findById(taskId)
    val original = CiCloneHelper.cloneCi(task)
    LockedTaskOperationChecks.checkRemoveWatcher(task)
    task.removeWatcher(watcher)
    taskRepository.update(task)
    eventBus.publish(TaskUpdatedEvent(original, task))
    task.getWatchers
  }

  @Timed
  def updateWatchers(taskId: String, updatedWatchers: JSet[String]): JSet[String] = {
    val task: Task = taskRepository.findById(taskId)
    val original = CiCloneHelper.cloneCi(task)
    LockedTaskOperationChecks.checkUpdateWatchers(task)
    task.setWatchers(updatedWatchers)
    taskRepository.update(task)
    eventBus.publish(TaskUpdatedEvent(original, task))
    task.getWatchers
  }



}
