package com.xebialabs.xlrelease.utils

import com.xebialabs.deployit.security.permission.{Permission, PermissionHandler}
import com.xebialabs.deployit.security.{PermissionDeniedException, Permissions}

object ScopedTokenPermissionValidator {

  def checkPermissionSupportedinScopedToken(permissions: Permission*): Unit = {
    if (Permissions.isPersonalAccessToken && !Permissions.isLegacyPersonalAccessToken && permissions.exists(_.getLevel == PermissionHandler.Level.CI)) {
      throw new PermissionDeniedException("The requested functionality is not supported with your personal access token")
    }
  }
}
