package com.xebialabs.xlrelease.views;


import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;

import java.util.Date;

public class DependencyView {

    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String id;

    private VariableOrDependencyView variableOrTarget;

    private boolean resolved;

    private boolean archived;

    protected String lastModifiedBy;

    protected Date lastModifiedAt;

    public DependencyView() {
    }

    public DependencyView(String dependencyId, VariableOrDependencyView variableOrTarget, boolean resolved, boolean archived) {
        this.id = dependencyId;
        this.variableOrTarget = variableOrTarget;
        this.resolved = resolved;
        this.archived = archived;
    }

    public String getId() {
        return id;
    }

    public String toTargetIdOrVariable() {
        return hasFixedTarget() ? toTargetId() : variableOrTarget.getVariable();
    }

    public String toTargetId() {
        return variableOrTarget.getValue().toNodeId();
    }

    public boolean isResolved() {
        return resolved;
    }

    public boolean isArchived() {
        return archived;
    }

    public VariableOrDependencyView getVariableOrTarget() {
        return variableOrTarget;
    }

    public void setVariableOrTarget(final VariableOrDependencyView variableOrTarget) {
        this.variableOrTarget = variableOrTarget;
    }

    public boolean hasFixedTarget() {
        return getVariableOrTarget().getValue() != null;
    }

    public String getLastModifiedBy() {
        return lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModifiedAt() {
        return lastModifiedAt;
    }

    public void setLastModifiedAt(Date lastModifiedAt) {
        this.lastModifiedAt = lastModifiedAt;
    }
}
