/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.authorization;

import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.security.authentication.RunnerAuthenticationToken;
import com.xebialabs.xlrelease.security.authority.TenantAuthority;
import com.xebialabs.xlrelease.service.UserLastActiveActorService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.utils.TenantContext;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;

public class LoginAuthorizationManager<T>
implements AuthorizationManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(LoginAuthorizationManager.class);
    private final UserProfileService userProfileService;
    private final UserLastActiveActorService userLastActiveActorService;

    public LoginAuthorizationManager(UserProfileService userProfileService, UserLastActiveActorService userLastActiveActorService) {
        this.userProfileService = userProfileService;
        this.userLastActiveActorService = userLastActiveActorService;
    }

    public AuthorizationDecision check(Supplier<Authentication> authentication, T object) {
        boolean granted = this.isGranted(authentication.get());
        return new AuthorizationDecision(granted);
    }

    private boolean isGranted(Authentication authentication) {
        return authentication != null && authentication.isAuthenticated() && this.isAuthorized(authentication);
    }

    private boolean isAuthorized(Authentication authentication) {
        String username = authentication.getName();
        logger.debug("Checking if login allowed for [{}]", (Object)username);
        if (authentication instanceof RunnerAuthenticationToken) {
            return true;
        }
        if (XLReleasePermissions.isAdmin((String)username)) {
            LoginAuthorizationManager.addAuthenticatedUserAuthority(authentication, TenantContext.SYSTEM_TENANT_ID());
            this.userLastActiveActorService.updateLastActive("admin");
            return true;
        }
        UserProfile userProfile = this.userProfileService.findByUsername(username);
        if (userProfile != null && userProfile.isLoginAllowed()) {
            if (userProfile.getLastActive() == null) {
                if (this.userProfileService.areLicensesAvailable()) {
                    logger.debug("Allocating license for user [{}]", (Object)username);
                    this.userProfileService.updateLastActive(userProfile.getCanonicalId(), new Date(), true);
                } else {
                    logger.error("User [{}] is not authorized for login. There are no available seats left under your Release license. Please contact your Release administrator for further assistance.", (Object)username);
                    return false;
                }
            }
            logger.debug("User [{}] is authorized for login", (Object)username);
            this.onAccessGranted(authentication, userProfile);
            return true;
        }
        logger.error("User [{}] is not authorized for login", (Object)username);
        return false;
    }

    private void onAccessGranted(Authentication authentication, UserProfile userProfile) {
        this.userLastActiveActorService.updateLastActive(userProfile.getCanonicalId());
        Authentication newAuthentication = LoginAuthorizationManager.addAuthenticatedUserAuthority(authentication, userProfile.getTenantId());
        SecurityContext newCtxt = SecurityContextHolder.createEmptyContext();
        newCtxt.setAuthentication(newAuthentication);
        SecurityContextHolder.setContext((SecurityContext)newCtxt);
    }

    public static Authentication addAuthenticatedUserAuthority(Authentication authentication, String tenantId) {
        Collection authorities = authentication.getAuthorities().stream().filter(authority -> !(authority instanceof TenantAuthority)).collect(Collectors.toCollection(HashSet::new));
        authorities.add(new SimpleGrantedAuthority("authenticated-user"));
        if (StringUtils.hasText((String)tenantId)) {
            authorities.add(new TenantAuthority(tenantId));
        }
        try {
            Field authoritiesField = LoginAuthorizationManager.findAuthoritiesField(authentication.getClass());
            authoritiesField.setAccessible(true);
            authoritiesField.set(authentication, Collections.unmodifiableCollection(authorities));
        }
        catch (Exception ex) {
            logger.error("Unable to set authenticated-user authority into authentication", (Throwable)ex);
        }
        return authentication;
    }

    private static Field findAuthoritiesField(Class<?> clazz) throws NoSuchFieldException {
        while (clazz != null) {
            try {
                return clazz.getDeclaredField("authorities");
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new NoSuchFieldException("Field 'authorities' not found in the class hierarchy.");
    }
}

