/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.param.IdParam;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.PermissionContext;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.CommentView;
import com.xebialabs.xlrelease.views.converters.CommentViewConverter;
import io.micrometer.core.annotation.Timed;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/comments")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class CommentResource {
    private final CommentService commentService;
    private final TaskRepository taskRepository;
    private final PermissionChecker permissions;
    private final CommentViewConverter commentViewConverter;

    @Autowired
    public CommentResource(CommentService commentService, TaskRepository taskRepository, PermissionChecker permissions, CommentViewConverter commentViewConverter) {
        this.commentService = commentService;
        this.taskRepository = taskRepository;
        this.permissions = permissions;
        this.commentViewConverter = commentViewConverter;
    }

    @PUT
    @Timed
    @Path(value="{commentId}")
    public CommentView updateComment(@PathParam(value="commentId") @IdParam String commentId, CommentView commentView) {
        String taskId = Ids.getParentId((String)commentId);
        String releaseId = Ids.releaseIdFrom((String)taskId);
        PermissionContext pc = this.permissions.context();
        pc.checkIsAllowedToCommentOnTask(taskId);
        if (pc.canEditTask(releaseId) || commentView.getAuthor().getUsername().equalsIgnoreCase(User.AUTHENTICATED_USER.getName())) {
            Object task = this.taskRepository.findById(taskId, ResolveOptions.WITH_DECORATORS());
            Comment comment = this.commentService.update((Task)task, commentId, commentView.getText());
            return this.commentViewConverter.toFullView(comment);
        }
        throw PermissionDeniedException.withMessage((String)String.format("You cannot comment on task [%s]", taskId));
    }

    @DELETE
    @Timed
    @Path(value="{commentId}")
    public void deleteComment(@PathParam(value="commentId") @IdParam String commentId, CommentView commentView) {
        String taskId = Ids.getParentId((String)commentId);
        String releaseId = Ids.releaseIdFrom((String)taskId);
        PermissionContext pc = this.permissions.context();
        pc.checkIsAllowedToCommentOnTask(taskId);
        if (!pc.canEditTask(releaseId) && !commentView.getAuthor().getUsername().equalsIgnoreCase(User.AUTHENTICATED_USER.getName())) {
            throw PermissionDeniedException.withMessage((String)String.format("You cannot delete comment on task [%s]", taskId));
        }
        Object task = this.taskRepository.findById(taskId, ResolveOptions.WITH_DECORATORS());
        this.commentService.delete((Task)task, commentId);
    }
}

