/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.customscripts;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.ContainerTask;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.ExportHook;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.utils.TaskTypes;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.events.system.TypesReloaded;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ScriptTypes {
    private Collection<Type> pythonScriptTypes;
    private Collection<Type> containerTaskTypes;
    private Collection<Type> releaseTriggerTypes;
    private Collection<Type> exportHookTypes;
    public static final Set<Type> UNKNOWN_TYPES = Set.of(CustomScriptTask.UNKNOWN_TYPE, Task.UNKNOWN_TASK_TYPE);
    private static final Logger logger = LoggerFactory.getLogger(ScriptTypes.class);

    public ScriptTypes(EventBus eventBus) {
        eventBus.register((Object)this);
        this.reload();
    }

    @Subscribe
    public void onTypesReloaded(TypesReloaded event) {
        this.reload();
    }

    private void reload() {
        this.pythonScriptTypes = this.getTypes("Custom Tasks", PythonScript.class);
        this.containerTaskTypes = this.getTypes("Container Tasks", ContainerTask.class);
        this.releaseTriggerTypes = this.getTypes("Release triggers", ReleaseTrigger.class);
        this.exportHookTypes = this.getTypes("Export hooks", ExportHook.class);
    }

    public Collection<Type> getPythonScriptTypes() {
        return this.pythonScriptTypes;
    }

    public Collection<Type> getContainerTaskTypes() {
        return this.containerTaskTypes;
    }

    public Collection<Type> getReleaseTriggerTypes() {
        return this.releaseTriggerTypes;
    }

    public Collection<Type> getExportHookTypes() {
        return this.exportHookTypes;
    }

    private List<Type> getTypes(String label, Class<? extends ConfigurationItem> type) {
        List<Type> types = TaskTypes.getTypes(type).stream().filter(t -> !UNKNOWN_TYPES.contains(t)).collect(Collectors.toList());
        StringBuffer typeList = new StringBuffer("\n");
        for (Type t2 : types) {
            typeList.append("  ").append(t2).append("\n");
        }
        logger.info("{}: {}", (Object)label, (Object)typeList);
        return types;
    }
}

