package com.xebialabs.xlrelease.server.jetty

import com.xebialabs.deployit.engine.spi.event.SystemStartedEvent
import com.xebialabs.deployit.event.EventBusHolder
import com.xebialabs.deployit.{ServerConfiguration, ServerState}
import com.xebialabs.xlrelease.XLReleaseBootstrapper
import com.xebialabs.xlrelease.config.XlrConfig
import grizzled.slf4j.Logging
import org.springframework.boot.context.event.{ApplicationFailedEvent, ApplicationReadyEvent}
import org.springframework.context.event.EventListener

import java.lang.System.err

class JettyServerListener(val serverConfiguration: ServerConfiguration, val xlrConfig: XlrConfig) extends Logging {
  final private val serverState = ServerState.getInstance

  @EventListener
  def onApplicationReadyEvent(event: ApplicationReadyEvent): Unit = {
    EventBusHolder.register(serverState)
    if (!xlrConfig.maintenanceModeEnabled) {
      EventBusHolder.publish(new SystemStartedEvent)
      logger.info(s"${XLReleaseBootstrapper.PRODUCT_DIGITALAI} has started.")
    } else {
      logger.info(s"${XLReleaseBootstrapper.PRODUCT_DIGITALAI} has started in maintenance mode.")
    }
    //TODO S-114524 Implement more sophisticated logic to determine if the node is up and ready to accept customer traffic.
    //Currently this event firing means that you can open the server URL in the browser and see the login page.
    //However, in the clustered environment pekko cluster is not formed yet and actor system is not ready, which leads application getting stuck at login page.
    logger.info(s"You can now point your browser to ${serverConfiguration.getServerUrl}\n")
  }

  @EventListener
  def onApplicationFailedEvent(event: ApplicationFailedEvent): Unit = {
    val displayMsg = String.format("%s Startup failed: %s%n", XLReleaseBootstrapper.PRODUCT_DIGITALAI, event.getException.getMessage)
    err.println()
    err.println("################################################################################")
    err.println()
    err.println(displayMsg)
    err.println()
    err.println("################################################################################")
    err.println()
  }

}
