package com.xebialabs.xlrelease.upgrade;

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.configuration.{RiskCalculationSettings, TaskTimeoutSettings}
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.support.config.TypesafeConfigExt.ExtendedConfig
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.{BaseInitializingUpgrade, ClassNameToString}
import grizzled.slf4j.Logging

import scala.concurrent.duration.DurationInt
import scala.language.postfixOps

class ReferenceSettingsMigrationInitializingUpgrade(xlrConfig: XlrConfig,
                                                    configurationRepository: ConfigurationRepository)
  extends BaseInitializingUpgrade with Logging with ClassNameToString {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "25.3.0#0")

  override def doUpgrade(): Boolean = {
    logger.info("Reference settings migration upgrade")

    createRiskCalculationSettings()
    createTaskTimeoutSettings()

    logger.debug("Finished reference settings migration upgrade")
    true
  }

  private def createRiskCalculationSettings(): Unit = {
    val riskEnabled = xlrConfig.getXl.getOptionalConfig("features").forall(_.getOptionalBoolean("risk.calculation.enabled").getOrElse(true))
    val riskSettings = createConfiguration(RiskCalculationSettings.SETTINGS_ID, classOf[RiskCalculationSettings])
    riskSettings.setEnabled(riskEnabled)
    configurationRepository.create(riskSettings)
  }

  private def createTaskTimeoutSettings(): Unit = {
    val timeouts = xlrConfig.getXl.getConfig("timeouts")

    val failureHandlerTimeout = timeouts.getOptionalDuration("failureHandlerTimeout").getOrElse(120 seconds).toSeconds.toInt

    val scriptTaskTimeoutEnabled = timeouts.getOptionalBoolean("scriptTaskTimeoutEnabled").getOrElse(false)
    val scriptTaskTimeout = timeouts.getOptionalDuration("scriptTaskTimeout").getOrElse(300 seconds).toSeconds.toInt

    val customScriptTaskTimeoutEnabled = timeouts.getOptionalBoolean("customScriptTaskTimeoutEnabled").getOrElse(false)
    val customScriptTaskTimeout = timeouts.getOptionalDuration("customScriptTaskTimeout").getOrElse(300 seconds).toSeconds.toInt

    val preconditionTimeoutEnabled = timeouts.getOptionalBoolean("preconditionTimeoutEnabled").getOrElse(false)
    val preconditionTimeout = timeouts.getOptionalDuration("preconditionTimeout").getOrElse(300 seconds).toSeconds.toInt

    val timeoutSettings = createConfiguration(TaskTimeoutSettings.SETTINGS_ID, classOf[TaskTimeoutSettings])
    timeoutSettings.setFailureHandlerTimeout(failureHandlerTimeout)
    timeoutSettings.setScriptTaskTimeoutEnabled(scriptTaskTimeoutEnabled)
    timeoutSettings.setScriptTaskTimeout(scriptTaskTimeout)
    timeoutSettings.setCustomScriptTaskTimeoutEnabled(customScriptTaskTimeoutEnabled)
    timeoutSettings.setCustomScriptTaskTimeout(customScriptTaskTimeout)
    timeoutSettings.setPreconditionTimeoutEnabled(preconditionTimeoutEnabled)
    timeoutSettings.setPreconditionTimeout(preconditionTimeout)

    configurationRepository.create(timeoutSettings)
  }
}


