package com.xebialabs.xlrelease.views.converters

import com.xebialabs.xlrelease.domain.OriginTemplateData
import com.xebialabs.xlrelease.views.OriginTemplateDataView
import org.springframework.stereotype.Component

@Component
class OriginTemplateDataViewConverter extends ReleaseExtensionViewConverter[OriginTemplateData, OriginTemplateDataView] {
  override def getReleaseExtensionClass: Class[OriginTemplateData] = classOf[OriginTemplateData]

  override def toView(originTemplateData: OriginTemplateData): OriginTemplateDataView = {
    val view = new OriginTemplateDataView(
      originTemplateData.getOriginTemplateId,
      originTemplateData.getOriginTemplateTitle
    )
    view.setId(originTemplateData.getId)
    view
  }
}
