package com.xebialabs.xlrelease.scheduler.service

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.scheduler.filters.JobFilters
import com.xebialabs.xlrelease.scheduler.{JobQueue, JobStatus}
import org.springframework.data.domain.Pageable
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._

@Service
class DatabaseJobProvider(jobQueue: JobQueue, jobService: JobService) {

  private lazy val maxThreadsCount: Int = XlrConfig.getInstance.executors.scheduler.maxThreadsCount

  def queueJobsFromDatabase(): Unit = {
    val filters = new JobFilters()
    filters.withoutNode = false
    filters.status = List(JobStatus.QUEUED.name()).asJava

    val foundJobs = jobService.findAllTaskJobs(filters, Pageable.ofSize(maxThreadsCount), ignoreUnknownType = true)
    foundJobs.foreach(jobQueue.submitExisting)
  }

}
