package com.xebialabs.xlrelease.upgrade

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.configuration.ReleasePasswordSettings
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.{BaseInitializingUpgrade, ClassNameToString}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class ReleasePasswordSettingInitializingUpgrade @Autowired()(configurationRepository: ConfigurationRepository)
  extends BaseInitializingUpgrade with Logging with ClassNameToString {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "26.1.0#0")

  override def doUpgrade(): Boolean = {
    logger.info("Release password settings upgrade")

    createReleasePasswordSettings()

    logger.debug("Finished release password settings upgrade")
    true
  }

  private def createReleasePasswordSettings(): Unit = {
    if (!configurationRepository.exists(ReleasePasswordSettings.PASSWORD_SETTINGS_ID)) {
      val releasePasswordSettings = createConfiguration(ReleasePasswordSettings.PASSWORD_SETTINGS_ID, classOf[ReleasePasswordSettings])
      releasePasswordSettings.setEnableAllowPasswordsInAllFields(false)
      configurationRepository.create(releasePasswordSettings)
      logger.info("Created ReleasePasswordSettings")
    } else {
      logger.info("ReleasePasswordSettings already exists, skipping creation")
    }
  }
}