package com.xebialabs.xlrelease.views.converters;

import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.search.PlanItemSearchResult;
import com.xebialabs.xlrelease.views.PlanItemSearchView;
import com.xebialabs.xlrelease.views.PlanItemView;

import static java.util.stream.Collectors.toList;

@Component
public class PlanItemViewConverter {

    public PlanItemSearchView toSearchView(PlanItemSearchResult searchResult) {
        return new PlanItemSearchView(searchResult.getPage(), searchResult.getItems()
                .entrySet()
                .stream()
                .map(entry -> new PlanItemView(entry.getKey(), entry.getValue()))
                .collect(toList()));
    }
}
