/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.service;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.management.ServiceStatus;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.service.DatabaseJobProvider;
import com.xebialabs.xlrelease.service.NoopXlrServiceLifecycle;
import com.xebialabs.xlrelease.service.XlrServiceLifecycle;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.stereotype.Service;
import scala.Enumeration;
import scala.Function0;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.DurationConverters;
import scala.jdk.DurationConverters$;
import scala.reflect.ScalaSignature;

@Service
@EnableScheduling
@Profile(value={"hot-standby", "full"})
@ScalaSignature(bytes="\u0006\u0005q4A\u0001C\u0005\u0001)!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0005\"B$\u0001\t\u0003A\u0005\"B'\u0001\t\u0003r\u0005\"B+\u0001\t\u00131\u0006\"\u0002.\u0001\t\u0003Z&\u0001\u0007&pEF+X-^3Q_B,H.\u0019;peN+'O^5dK*\u0011!bC\u0001\bg\u0016\u0014h/[2f\u0015\taQ\"A\u0005tG\",G-\u001e7fe*\u0011abD\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001E\t\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\n\u0002\u0007\r|Wn\u0001\u0001\u0014\u000b\u0001)R$\u000b\u0018\u0011\u0005YYR\"A\f\u000b\u0005aI\u0012\u0001\u00027b]\u001eT\u0011AG\u0001\u0005U\u00064\u0018-\u0003\u0002\u001d/\t1qJ\u00196fGR\u0004\"AH\u0014\u000e\u0003}Q!\u0001I\u0011\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002#G\u0005Q1o\u00195fIVd\u0017N\\4\u000b\u0005\u0011*\u0013aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\u0019\n1a\u001c:h\u0013\tAsD\u0001\u000bTG\",G-\u001e7j]\u001e\u001cuN\u001c4jOV\u0014XM\u001d\t\u0003U1j\u0011a\u000b\u0006\u0003\u00155I!!L\u0016\u0003/9{w\u000e\u001d-meN+'O^5dK2Kg-Z2zG2,\u0007CA\u00185\u001b\u0005\u0001$BA\u00193\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0019\u0014\u0001C4sSjTH.\u001a3\n\u0005U\u0002$a\u0002'pO\u001eLgnZ\u0001\tU>\u0014\u0017+^3vKB\u0011\u0001(O\u0007\u0002\u0017%\u0011!h\u0003\u0002\t\u0015>\u0014\u0017+^3vK\u0006\u0019B-\u0019;bE\u0006\u001cXMS8c!J|g/\u001b3feB\u0011QHP\u0007\u0002\u0013%\u0011q(\u0003\u0002\u0014\t\u0006$\u0018MY1tK*{'\r\u0015:pm&$WM]\u0001\nq2\u00148i\u001c8gS\u001e\u0004\"AQ#\u000e\u0003\rS!\u0001R\u0007\u0002\r\r|gNZ5h\u0013\t15IA\u0005YYJ\u001cuN\u001c4jO\u00061A(\u001b8jiz\"B!\u0013&L\u0019B\u0011Q\b\u0001\u0005\u0006m\u0011\u0001\ra\u000e\u0005\u0006w\u0011\u0001\r\u0001\u0010\u0005\u0006\u0001\u0012\u0001\r!Q\u0001\tO\u0016$xJ\u001d3feR\tq\n\u0005\u0002Q'6\t\u0011KC\u0001S\u0003\u0015\u00198-\u00197b\u0013\t!\u0016KA\u0002J]R\f\u0001\u0003]8qk2\fG/\u001a&pEF+X-^3\u0015\u0003]\u0003\"\u0001\u0015-\n\u0005e\u000b&\u0001B+oSR\fabY8oM&<WO]3UCN\\7\u000f\u0006\u0002X9\")Ql\u0002a\u0001=\u0006iA/Y:l%\u0016<\u0017n\u001d;sCJ\u0004\"aX1\u000e\u0003\u0001T!\u0001R\u0011\n\u0005\t\u0004'AF*dQ\u0016$W\u000f\\3e)\u0006\u001c8NU3hSN$(/\u0019:)\u0005\u0001!\u0007CA3i\u001b\u00051'BA4$\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0003S\u001a\u0014qaU3sm&\u001cW\r\u000b\u0002\u0001WB\u0011a\u0004\\\u0005\u0003[~\u0011\u0001#\u00128bE2,7k\u00195fIVd\u0017N\\4)\t\u0001ygo\u001e\t\u0003aRl\u0011!\u001d\u0006\u0003AIT!a]\u0012\u0002\u000f\r|g\u000e^3yi&\u0011Q/\u001d\u0002\b!J|g-\u001b7f\u0003\u00151\u0018\r\\;fY\tA(0I\u0001z\u0003-Aw\u000e^\u0017ti\u0006tGMY=\"\u0003m\fAAZ;mY\u0002")
public class JobQueuePopulatorService
implements SchedulingConfigurer,
NoopXlrServiceLifecycle {
    private final JobQueue jobQueue;
    private final DatabaseJobProvider databaseJobProvider;
    private final XlrConfig xlrConfig;
    private Enumeration.Value state;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public void doStart() {
        NoopXlrServiceLifecycle.doStart$(this);
    }

    @Override
    public void doStop() {
        NoopXlrServiceLifecycle.doStop$(this);
    }

    @Override
    public String serviceName() {
        return XlrServiceLifecycle.serviceName$(this);
    }

    @Override
    public void start() {
        XlrServiceLifecycle.start$(this);
    }

    @Override
    public void awaitStart() {
        XlrServiceLifecycle.awaitStart$(this);
    }

    @Override
    public void stop() {
        XlrServiceLifecycle.stop$(this);
    }

    @Override
    public void awaitStop() {
        XlrServiceLifecycle.awaitStop$(this);
    }

    @Override
    public boolean isRunning() {
        return XlrServiceLifecycle.isRunning$(this);
    }

    @Override
    public ServiceStatus serviceStatus() {
        return XlrServiceLifecycle.serviceStatus$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Enumeration.Value state() {
        return this.state;
    }

    @Override
    public void state_$eq(Enumeration.Value x$1) {
        this.state = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        JobQueuePopulatorService jobQueuePopulatorService = this;
        synchronized (jobQueuePopulatorService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public int getOrder() {
        return 47;
    }

    private void populateJobQueue() {
        if (this.isRunning() && this.jobQueue.isRunning() && this.jobQueue.size() == 0) {
            if (this.xlrConfig.maintenanceModeEnabled()) {
                this.logger().debug((Function0 & Serializable)() -> "[MAINTENANCE MODE] Job queue population - DISABLED");
                return;
            }
            this.logger().debug((Function0 & Serializable)() -> "Going to populate jobQueue with new jobs");
            this.databaseJobProvider.queueJobsFromDatabase();
            return;
        }
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        FiniteDuration delay = this.xlrConfig.durations().jobQueuePopulateInterval();
        taskRegistrar.addFixedDelayTask(() -> this.populateJobQueue(), DurationConverters.ScalaDurationOps$.MODULE$.toJava$extension(DurationConverters$.MODULE$.ScalaDurationOps(delay)));
    }

    public JobQueuePopulatorService(JobQueue jobQueue, DatabaseJobProvider databaseJobProvider, XlrConfig xlrConfig) {
        this.jobQueue = jobQueue;
        this.databaseJobProvider = databaseJobProvider;
        this.xlrConfig = xlrConfig;
        Logging.$init$((Logging)this);
        XlrServiceLifecycle.$init$(this);
        NoopXlrServiceLifecycle.$init$(this);
    }
}

