/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.base.Preconditions;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks$TaskUpdatePropertiesComparator$;
import java.util.Objects;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class LockedTaskOperationChecks$ {
    public static final LockedTaskOperationChecks$ MODULE$ = new LockedTaskOperationChecks$();

    public void checkAddWatcher(Task task) {
        this.checkState(!task.isLocked(), "You can not add a watcher on a locked task: %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle()}));
    }

    public void checkRemoveWatcher(Task task) {
        this.checkState(!task.isLocked(), "You can not remove a watcher on a locked task: %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle()}));
    }

    public void checkUpdateWatchers(Task task) {
        this.checkState(!task.isLocked(), "You can not update watchers on a locked task: %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle()}));
    }

    public void checkDeleteAttachment(Task task) {
        this.checkState(!task.isLocked(), "You can not delete an attachment from a locked task: %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle()}));
    }

    public void checkCreateGateCondition(Task task) {
        this.checkState(!task.isLocked(), "You can not add a condition to a locked task: %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle()}));
    }

    public void checkUpdateGateCondition(Task task, GateCondition originalGateCondition, GateCondition updatedGateCondition) {
        this.checkState(!task.isLocked() || Objects.equals(updatedGateCondition.getTitle(), originalGateCondition.getTitle()), "You can not edit condition on a gate task. You can only check or uncheck a condition.", (Seq<Object>)Nil$.MODULE$);
    }

    public void checkDeleteGateCondition(Task task) {
        this.checkState(!task.isLocked(), "You can not delete a condition on a locked task: %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle()}));
    }

    public void checkCreateDependency(Task task) {
        this.checkState(!task.isLocked(), "You can not add dependency to the locked task: %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle()}));
    }

    public void checkUpdateDependency(Task task) {
        this.checkState(!task.isLocked(), "You can not edit dependency on a locked task: %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle()}));
    }

    public void checkDeleteDependency(Task task) {
        this.checkState(!task.isLocked(), "You can not delete dependency from a locked task: %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle()}));
    }

    public void checkTaskUpdate(Task original, Task updatedTask) {
        this.checkState(!original.isLocked() || !LockedTaskOperationChecks$TaskUpdatePropertiesComparator$.MODULE$.hasChanged(original, updatedTask), "You can not update a locked task: %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{original.getTitle()}));
    }

    public void checkTaskTypeChange(Task task) {
        this.checkState(!task.isLocked(), "You can not change type of the locked task %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle()}));
        this.checkState(!task.getContainer().isLocked(), "You can not change type of a task %s inside of a locked container %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle(), task.getContainer().getTitle()}));
    }

    public void checkUpdateTeams(Task task) {
        this.checkState(!task.isLocked(), "You can not update teams of the locked task %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle()}));
    }

    public void checkUpdateOwner(Task task, String newOwner, PermissionChecker permissionChecker) {
        this.checkState(permissionChecker.isCurrentUserAdmin() || !task.isLocked() || permissionChecker.areUsersInTheSameTaskTeam(task, newOwner), "You can not update owner of the locked task: %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle()}));
    }

    public void checkDeleteTask(Task task) {
        this.checkState(!task.isLocked(), "You can not delete locked task: %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle()}));
        this.checkState(!task.getContainer().isLocked(), "You can not delete a task %s inside of a locked container %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle(), task.getContainer().getTitle()}));
    }

    public void checkMoveTask(Task task, TaskContainer originTaskContainer, TaskContainer targetTaskContainer) {
        this.checkState(!originTaskContainer.isLocked(), "You can not move task %s out of or within the locked container %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle(), originTaskContainer.getTitle()}));
        this.checkState(!targetTaskContainer.isLocked(), "You can not move task %s into the locked container %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle(), originTaskContainer.getTitle()}));
        this.checkState(!task.isLocked() || originTaskContainer.equals(targetTaskContainer), "Locked task %s cannot be moved between task container %s and %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle(), originTaskContainer.getId(), targetTaskContainer.getId()}));
    }

    public void checkSkipTask(Task task) {
        this.checkState(!task.isLocked(), "You can not skip locked task: %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle()}));
    }

    public void checkCompleteTaskInAdvance(Task task) {
        this.checkState(!task.isLocked(), "You can not complete in advance locked task %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle()}));
    }

    public void checkCopyTask(Task task) {
        this.checkState(!task.isLocked(), "Task '%s' cannot be copied because it is locked.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle()}));
        this.checkState(!task.getContainer().isLocked(), "Task '%s' cannot be copied into the locked group task '%s'.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{task.getTitle(), task.getContainer().getTitle()}));
    }

    public void checkCreateTaskInContainer(TaskContainer container) {
        this.checkState(!container.isLocked(), "You can't create a task inside of a locked container %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{container.getTitle()}));
    }

    public void checkCreateTaskLink(ParallelGroup parallelGroup) {
        this.checkState(!parallelGroup.isLocked(), "You can't add a link inside a locked task group %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{parallelGroup.getTitle()}));
    }

    public void checkRemoveTaskLink(ParallelGroup parallelGroup) {
        this.checkState(!parallelGroup.isLocked(), "You can't remove a link from a locked task group %s.", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{parallelGroup.getTitle()}));
    }

    private void checkState(boolean expr, String msg, Seq<Object> args) {
        if (args.isEmpty()) {
            Preconditions.checkState((boolean)expr, (Object)msg);
            return;
        }
        Preconditions.checkState((boolean)expr, (String)msg, (Object[])((Object[])args.toArray(ClassTag$.MODULE$.Object())));
    }

    private LockedTaskOperationChecks$() {
    }
}

