/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.param.IdParam;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.TeamUpdateOperation;
import com.xebialabs.xlrelease.service.TeamUpdateOperations;
import com.xebialabs.xlrelease.views.TeamView;
import com.xebialabs.xlrelease.views.converters.TeamMemberViewConverter;
import com.xebialabs.xlrelease.views.teams.TeamUpdateRequest;
import com.xebialabs.xlrelease.views.teams.TeamUpdateRequests;
import io.micrometer.core.annotation.Timed;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.collection.immutable.Seq;

@Path(value="/teams")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class TeamResource {
    private final Logger logger = LoggerFactory.getLogger(TeamResource.class);
    private final PermissionChecker permissions;
    private final ReleaseActorService releaseActorService;
    private final TeamService teamService;
    private final TeamMemberViewConverter teamMemberViewConverter;

    @Autowired
    public TeamResource(PermissionChecker permissions, ReleaseActorService releaseActorService, TeamService teamService, TeamMemberViewConverter teamMemberViewConverter) {
        this.permissions = permissions;
        this.releaseActorService = releaseActorService;
        this.teamService = teamService;
        this.teamMemberViewConverter = teamMemberViewConverter;
    }

    @GET
    @Timed
    @Path(value="{teamContainerId:.*(Release|Folder)[^/-]*}")
    public List<TeamView> getTeams(@PathParam(value="teamContainerId") @IdParam String teamContainerId) {
        this.permissions.checkViewTeams(teamContainerId);
        return this.teamService.getEffectiveTeamViews(teamContainerId, this.teamMemberViewConverter);
    }

    @DELETE
    @Timed
    @Path(value="/{teamContainerId:.*(Release|Folder)[^/-]*}")
    public void deleteAllOwnTeams(@PathParam(value="teamContainerId") @IdParam String teamContainerId) {
        this.permissions.checkDeleteOwnTeams(teamContainerId);
        if (Ids.isReleaseId((String)teamContainerId)) {
            this.releaseActorService.updateTeams(teamContainerId, Collections.emptyList());
        } else {
            this.teamService.deleteTeamsFromPlatform(teamContainerId);
        }
    }

    @POST
    @Timed
    @Path(value="{teamContainerId:.*(Release|Folder)[^/-]*}")
    public List<TeamView> replaceTeams(@PathParam(value="teamContainerId") @IdParam String teamContainerId, List<TeamView> updatedListOfTeams) {
        this.permissions.checkViewTeams(teamContainerId);
        String teamNames = updatedListOfTeams.stream().map(TeamView::getTeamName).collect(Collectors.joining(",", "[", "]"));
        Checks.checkArgument((boolean)this.isReleaseAdminTeamPresent(updatedListOfTeams), (String)"Cannot save teams %s in %s, missing 'Release Admin' team", (Object[])new Object[]{teamNames, teamContainerId});
        List<Team> submittedTeams = updatedListOfTeams.stream().map(TeamView::toTeam).collect(Collectors.toList());
        this.permissions.checkEditTeamsAgainstExisting(teamContainerId, submittedTeams);
        if (Ids.isReleaseId((String)teamContainerId)) {
            this.releaseActorService.updateTeams(teamContainerId, submittedTeams);
        } else {
            this.teamService.saveTeamsToPlatform(teamContainerId, submittedTeams);
        }
        return this.teamService.getTeamViews(teamContainerId);
    }

    @PUT
    @Timed
    @Path(value="update/{teamContainerId:.*(Folder)[^/-]*}")
    public Response updateTeamOperations(@PathParam(value="teamContainerId") @IdParam String teamContainerId, TeamUpdateRequests updateRequests) {
        this.permissions.checkViewTeams(teamContainerId);
        Seq<TeamUpdateRequest> requests = updateRequests.requests();
        TeamUpdateRequest.validate(teamContainerId, requests);
        Seq<TeamUpdateOperation> operations = TeamUpdateOperations.reduce(requests);
        this.permissions.checkEditTeams(teamContainerId, operations);
        try {
            this.teamService.executeTeamUpdateOperations(operations);
            return Response.ok().build();
        }
        catch (Exception e) {
            String errorMsg = "Unable to execute team update operations";
            throw new DeployitException((Throwable)e, errorMsg, new Object[0]);
        }
    }

    private boolean isReleaseAdminTeamPresent(List<TeamView> teamViewList) {
        return teamViewList.stream().anyMatch(team -> "Release Admin".equals(team.getTeamName()));
    }
}

