/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.xlrelease.domain.Task;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSoftReference<U extends Task> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskSoftReference.class);
    private final Integer releaseCiUid;
    private SoftReference<U> softReference;
    private String taskId;
    private String executionId;
    private Supplier<U> supplier;
    private Set<String> capabilities = new HashSet<String>();

    public TaskSoftReference(U task, Supplier<U> supplier) {
        this(task.getId(), task.getExecutionId(), task.getRelease().getCiUid(), supplier);
        this.softReference = new SoftReference<U>(task);
    }

    public TaskSoftReference(String taskId, String executionId, Integer releaseCiUid, Supplier<U> supplier) {
        this.softReference = new SoftReference<Object>(null);
        this.taskId = taskId;
        this.executionId = executionId;
        this.releaseCiUid = releaseCiUid;
        this.supplier = supplier;
    }

    public U get() {
        Task task = (Task)this.softReference.get();
        if (task == null) {
            LOGGER.debug("Reference GCed, going to read from database {}", (Object)this.taskId);
            task = (Task)this.supplier.get();
            this.softReference = new SoftReference<Task>(task);
        } else {
            LOGGER.debug("Reference survived {}", (Object)this.taskId);
        }
        return (U)task;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public Integer getReleaseCiUid() {
        return this.releaseCiUid;
    }

    public Set<String> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Set<String> capabilities) {
        if (capabilities != null) {
            this.capabilities = capabilities;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskSoftReference that = (TaskSoftReference)o;
        return this.taskId != null ? this.taskId.equals(that.taskId) : that.taskId == null;
    }

    public int hashCode() {
        return this.taskId != null ? this.taskId.hashCode() : 0;
    }

    public String toString() {
        return "TaskSoftReference{softReference=" + String.valueOf(this.softReference) + ", taskId='" + this.taskId + "', executionId='" + this.executionId + "', supplier=" + String.valueOf(this.supplier) + ", capabilities='" + String.join((CharSequence)", ", this.capabilities) + "'}";
    }
}

