/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.data.domain.Chunk;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class ReleasePageImpl<T>
extends Chunk<T>
implements Page<T> {
    private static final long serialVersionUID = -6969139863724462053L;
    private final long total;

    public ReleasePageImpl(List<T> content, Pageable pageable, long total) {
        super(content, pageable);
        this.total = total;
    }

    public ReleasePageImpl(List<T> content) {
        this(content, Pageable.unpaged(), content.size());
    }

    public int getTotalPages() {
        return this.getSize() == 0 ? 1 : (int)Math.ceil((double)this.total / (double)this.getSize());
    }

    public long getTotalElements() {
        return this.total;
    }

    public boolean hasNext() {
        return this.getNumber() + 1 < this.getTotalPages();
    }

    public boolean isLast() {
        return !this.hasNext();
    }

    public <U> Page<U> map(Function<? super T, ? extends U> converter) {
        return new ReleasePageImpl<T>(this.getConvertedContent(converter), this.getPageable(), this.total);
    }

    public String toString() {
        String contentType = "UNKNOWN";
        List content = this.getContent();
        if (!content.isEmpty() && content.get(0) != null) {
            contentType = content.get(0).getClass().getName();
        }
        return String.format("Page %s of %d containing %s instances", this.getNumber() + 1, this.getTotalPages(), contentType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReleasePageImpl that = (ReleasePageImpl)((Object)o);
        return this.total == that.total;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.total);
    }
}

